float Blinn_Phong(vec3 ppos, vec3 lightDir, vec3 surfaceNormal, float gloss)  {
	vec3 viewDirection = normalize(-ppos);
	vec3 halfAngle = normalize(lightDir + viewDirection);
	float blinnTerm = clamp(dot(surfaceNormal, halfAngle),0.0,1.0);
	float pi = 3.1415927;
	float n =  pow(2.0,gloss);
	return pow(blinnTerm, n )*pow(2.0,gloss)/256.0;
}