#version 120

/*
BSL Shaders by Capt Tatsu
http://bitslablab.wixsite.com/main
*/

#define AA
#define LightShaft

#ifdef LightShaft
const bool colortex1MipmapEnabled = true;
#endif

varying vec2 texcoord;

uniform float aspectRatio;
uniform float viewWidth;
uniform float viewHeight;

uniform sampler2D colortex1;

float luma(vec3 color){
	return dot(color,vec3(0.299, 0.587, 0.114));
}

#include "lib/post/antialiasing.glsl"

void main() {
	vec3 color = texture2D(colortex1,texcoord.xy).rgb;
	
	//Antialiasing
	#ifdef AA
	color = fxaa311(color);
	#endif
	
/*DRAWBUFFERS:1*/

	gl_FragColor = vec4(color,1.0);

}
