#version 120

/*
BSL Shaders by Capt Tatsu
http://bitslablab.wixsite.com/main
*/

varying vec3 upVec;
varying vec3 sunVec;

uniform int isEyeInWater;
uniform int worldTime;

uniform float nightVision;
uniform float rainStrength;
uniform float viewWidth;
uniform float viewHeight;

uniform ivec2 eyeBrightnessSmooth;

uniform mat4 gbufferProjectionInverse;

float time = float(worldTime);
float tB = max(sin(time/12000*22/7),0.0);
float eBS = eyeBrightnessSmooth.y/240.0;
float sunVisibility = pow(clamp(dot(sunVec,upVec)+0.1,0.0,0.1)/0.1,2.0);
float moonVisibility = pow(clamp(dot(-sunVec,upVec)+0.1,0.0,0.1)/0.1,2.0);

void main() {
	
	//Render Sky
	vec3 albedo = vec3(0.0);
	
/* DRAWBUFFERS:0 */

	gl_FragData[0] = vec4(albedo,1.0);
}